const levels = [
    { question: "Click the letter A", options: ["A", "B", "C"], answer: "A" },
    { question: "Find number 5", options: ["4", "5", "6"], answer: "5" },
    { question: "Choose color Blue", options: ["Red", "Blue", "Green"], answer: "Blue" },
    { question: "Click the fruit 🍎", options: ["🍎", "🍌", "🍉"], answer: "🍎" },
    { question: "Find letter C", options: ["A", "B", "C"], answer: "C" },
    { question: "Select the number 8", options: ["7", "8", "9"], answer: "8" },
    { question: "Click the 🦋", options: ["🦄", "🦋", "🐞"], answer: "🦋" },
    { question: "Press Red", options: ["Red", "Yellow", "Green"], answer: "Red" },
    { question: "Find 🐠", options: ["🐠", "🦀", "🐬"], answer: "🐠" },
    { question: "Select Letter D", options: ["C", "D", "E"], answer: "D" }
];

let params = new URLSearchParams(window.location.search);
let level = parseInt(params.get("level")) || 1;
let score = parseInt(localStorage.getItem("score")) || 0;

const questionEl = document.getElementById("question");
const optionsEl = document.getElementById("options");
const levelTitle = document.getElementById("level-title");
const scoreDisplay = document.getElementById("score-display");
const messageEl = document.getElementById("message");

function loadLevel() {
    levelTitle.textContent = `Level ${level}`;
    scoreDisplay.textContent = score;
    questionEl.textContent = levels[level - 1].question;

    optionsEl.innerHTML = "";
    levels[level - 1].options.forEach(opt => {
        const button = document.createElement("button");
        button.classList.add("btn");
        button.textContent = opt;
        button.onclick = () => checkAnswer(opt);
        optionsEl.appendChild(button);
    });
}

function checkAnswer(answer) {
    const correctAudio = new Audio("assets/correct.mp3");
    const wrongAudio = new Audio("assets/wrong.mp3");

    if (answer === levels[level - 1].answer) {
        // Jika jawapan betul
        correctAudio.play();
        messageEl.style.color = "green";
        messageEl.textContent = "Correct!";
        score += 10;
        localStorage.setItem("score", score);

        setTimeout(nextLevel, 1000); // Pergi ke soalan seterusnya
    } else {
        // Jika jawapan salah
        wrongAudio.play();
        messageEl.style.color = "red";
        messageEl.textContent = "Wrong! Moving to next level...";

        setTimeout(nextLevel, 1000); // Pergi ke level seterusnya selepas 1 saat
    }
}


function nextLevel() {
    if (level < levels.length) {
        level++;
        window.location.href = `game.php?level=${level}`;
    } else endGame();
}

function endGame() {
    window.location.href = "score.php";
}

loadLevel();
